* Replication files for
* "Capital Reallocation and the Cyclicality of Aggregate Productivity" by Russ Cooper & Immo Schott
* Prepared: May 2023

* Table 3 (data row)

use year R_frac* RK* logR* sd_APK_* logAtilde* logGDP_* dtfp* using "$datapath/macrodata_coopimmo.dta", clear
* Correlation between reallocation and Atilde
qui pwcorr logR_res logAtilde_res, star(.01)
gen c_R_Atilde = r(rho)

* Correlation between Atilde and the std of APK
pwcorr logAtilde_res sd_APK_res, star(.01)  
gen c_Atilde_APKdisp = r(rho)

* Correlation between Atilde and the fraction of reallocators
pwcorr logAtilde_res R_frac_res, star(.01)
gen c_Atilde_Rfrac = r(rho)

* Autocorrelation of Atilde
reg logAtilde_res l.logAtilde_res
gen AR1_Atilde = _b[l.logAtilde_res]

preserve
collapse c_R_Atilde c_Atilde_APKdisp c_Atilde_Rfrac AR1_Atilde
save tmp1.dta, replace
restore

* Standard deviation of R/K and TFP changes
collapse (sd) RK_res R_frac_res dtfp 

replace dtfp = dtfp / 100

append using tmp1.dta

save "$mainpath/Tables/Tables_data/Table3.dta", replace
